unit Cargo01;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls,
  Dialogs, ExtCtrls,
  Service03, UserApp03Data;

// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
type TCargo = class(TObject)
private
   fImg      : TImage;       //  Image
   // ---------------------
   fBmp      : TBitMap;      //   Image   
   fVisible  : boolean;      //   
   // ---------------------
   //       
   // ---------------------
   //  
   fIndx     : integer;      //   
   fId       : string;       //  
   fXB       : extended;     // X - (.)   
   fYB       : extended;     // Y - (.)   

   fXC       : extended;     // X - (.)   
   fYC       : extended;     // Y - (.)   
   fZC       : extended;     // Z - (.)   

   fWFull    : extended;     //  (.)  
   // ---------------------
   //  
   fCutout   : TRect;        //  Rect  
   // ---------------------
   //      
   // ---------------------
   //        
   fVector   : TVector3D;
   // ---------------------
   fMRoll    : extended;     //    
   fMPitch   : extended;     //    
   fMTurn    : extended;     //    
   // ---------------------
   procedure   ShowCargo();
   //  property
   procedure SetVisible(RqVisible : boolean);
public
   constructor Create(RqImage : TImage);
   procedure   Free();
   // ------------------
   //   
   property Visible    : boolean read fVisible write SetVisible;
   // ------------------
   //     
   // -----------------
   property Indx       : integer  read fIndx write fIndx;
   property Id         : string   read fId write fId;
   property XB         : extended read fXB write fXB;
   property YB         : extended read fYB write fYB;
   property XC         : extended read fXC write fXC;
   property YC         : extended read fYC write fYC;
   property ZC         : extended read fZC write fZC;
   property WFull      : extended read fWFull write fWFull;
   // ------------------
   //     
   // -----------------
   //  
   property Cutout     : TRect     read fCutout write fCutout;
   //      
   property Vector     : TVector3D read fVector write fVector;
   //  ,  
   property MRoll      : extended read fMRoll;
   property MPitch     : extended read fMPitch;
   property MTurn      : extended read fMTurn;
end;

// -------------------------------------------------------------------------
// -------------------------------------------------------------------------

implementation

// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
constructor TCargo.Create(RqImage : TImage);
begin
   inherited Create;
   fImg := RqImage;
   fBmp := TBitMap.Create;
   fBmp.PixelFormat := pf24bit;
   FillChar(fCutout, SizeOf(TRect), #0);
   fVisible := False;
end;
// -------------------------------------------------------------------------
procedure TCargo.Free();
begin
   if Assigned(fBmp) then fBmp.Free;
   inherited Free();
end;
// -------------------------------------------------------------------------
procedure TCargo.ShowCargo();
var wFontName : string;
    wFontSize : integer;
begin
   with fImg.Canvas do
   begin
       Pen.Width := 1;
       Brush.Color := RGB(200,230,250);
       Brush.Style := bsSolid;
       Rectangle(fCutout);
       wFontName := Font.Name;
       wFontSize := Font.Size;
       Font.Color := clBlack;
       Font.Name  := 'Arial';
       Font.Size  := 7;
       TextOut(fCutout.Left + 4, fCutout.Top + 4,
               '' + IntToStr(fIndx));
       TextOut(fCutout.Left + 4, fCutout.Top + 4 + TextHeight('1'),
               Format('%4.0f', [fWFull]));
       Font.Name := wFontName;
       Font.Size := wFontSize;
   end;
end;

// -------------------------------------------------------------------------
//   
procedure TCargo.SetVisible(RqVisible : boolean);
begin
   //  
   // -----------------------------
   if RqVisible
   then begin
      if (not fVisible)
      then begin
         //     
         SaveBitMap(fImg.Picture.Bitmap, fBmp, fCutout);
         //  
         ShowCargo();
         fVisible := True;
      end;
   end
   else begin
      if fVisible
      then begin
         //  
         RestoreBitMap(fBmp,                 // BitMap 
                       fImg.Picture.Bitmap,  // BitMap 
                       fCutout.Left, fCutout.Top);
        fImg.Refresh;
        fVisible := False;
      end;
   end;
end;

// -------------------------------------------------------------------------
// -------------------------------------------------------------------------

end.
